/*
 * ECE3884 Lab03
 * Georgia Institute of Technology
 * Your Name: 
 */

/* ----------------------------------------------------------------------------
 *         ATMEL Microcontroller Software Support 
 * ----------------------------------------------------------------------------
 * Copyright (c) 2008, Atmel Corporation
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Atmel's name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ----------------------------------------------------------------------------
 */

/* 
 * Credits to Karl Zeilhofer
 * mailto: zeilhofer - gmail - com
 * for AT91SAM analog example
 */


//------------------------------------------------------------------------------
//         Headers
//------------------------------------------------------------------------------

#include <board.h>
#include <pio/pio.h>
#include <aic/aic.h>
#include <dbgu/dbgu.h>
#include <pwmc/pwmc.h>
#include <tc/tc.h>
#include <stdio.h>


//------------------------------------------------------------------------------
//         Local definitions
//------------------------------------------------------------------------------

/// Number of PWM outputs per ADC inputs
#define SUBSAMPLES                  1

/// PWM frequency in Hz.
#define PWM_FREQUENCY               44100  // 44.1kHZ * 4 

/// Maximum duty cycle value.
#define MAX_DUTY_CYCLE              511
#define MIN_DUTY_CYCLE              0

//------------------------------------------------------------------------------
//         Local variables
//------------------------------------------------------------------------------

/// Pio pins to configure.
#define PIN_PIOC_0 {0x01, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_OUTPUT_0, PIO_PULLUP}
#define PIN_PIOC_1 {0x02, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_OUTPUT_0, PIO_PULLUP}
#define PIN_PIOC_2 {0x04, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_OUTPUT_0, PIO_PULLUP}
#define PIN_PIOC_3 {0x08, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_OUTPUT_0, PIO_PULLUP}
#define PIN_PIOC_4 {0x10, AT91C_BASE_PIOC, AT91C_ID_PIOC, PIO_OUTPUT_0, PIO_PULLUP}

static const Pin Pins_3884[] = {
    PIN_PIOC_0,
    PIN_PIOC_1,
    PIN_PIOC_2,
    PIN_PIOC_3,
    PIN_PIOC_4
};

static const Pin pins[] = {

    PINS_DBGU,
    PIN_PWMC_PWM1
};

///Sine and Square wave duty cycles (MAX_DUTY_CYCLE = 127)
#define SIGLEN 64
int SinSquare = 0;

const int SIN64 [SIGLEN] = {\
63,57,51,45,39,33,28,23,18,14,\
10,7,4,2,1,0,0,1,2,3,6,9,12,16,\
21,25,31,36,42,48,55,61,67,74,\
80,86,92,97,102,107,112,115,\
119,122,124,126,127,127,127,\
126,124,122,120,116,113,108,\
104,98,93,87,81,75,69};

const int SQUARE64 [SIGLEN] = {\
0,0,0,0,0,0,0,0,0,0,\
0,0,0,0,0,0,0,0,0,0,\
0,0,0,0,0,0,0,0,0,0,\
0,0,127,127,127,127,127,127,127,127,\
127,127,127,127,127,127,127,127,127,127,\
127,127,127,127,127,127,127,127,127,127,\
127,127,127,127};

volatile int adcValue = 0;

//------------------------------------------------------------------------------
//         Local functions
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/// Interrupt handler for the PWM controller. Counts the number of periods and
/// updates the duty cycle after a given number.
//------------------------------------------------------------------------------
static void ISR_PWM(void)
{
    static unsigned int count = 0;
    static unsigned int duty = MAX_DUTY_CYCLE >> 1;
    
    // If this interrupt was triggered by PWM channel 1
    if ((AT91C_BASE_PWMC->PWMC_ISR & AT91C_PWMC_CHID1) == AT91C_PWMC_CHID1) {

      /* Insert ADC ISR Code Below Here*/
        // if Analog conversion ready
        if(count >= SUBSAMPLES && (AT91C_BASE_ADC->ADC_SR & (1<<3))) {
            adcValue = AT91C_BASE_ADC->ADC_LCDR; // read result of last conversion
            duty = adcValue>>1; // Right Shift by 1 converts 10-bit into 9-bit
            AT91C_BASE_ADC->ADC_CR = 1<<1; // start a new conversion
            count = 0;
        }
        count ++;
        // Set new duty cycle
        PWMC_SetDutyCycle(1, duty);
    }
}
   
//------------------------------------------------------------------------------
//         Global functions
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/// Outputs a PWM on Channel
//------------------------------------------------------------------------------
int main(void)
{
    PIO_Configure(pins, PIO_LISTSIZE(pins));
    PIO_Configure(Pins_3884, PIO_LISTSIZE(Pins_3884));
    
    DBGU_Configure(DBGU_STANDARD, 115200, BOARD_MCK);
    printf("\n\r -- ECE3884 lab03 --\n\r");

    // Enable PWMC peripheral clock and ADC clock
    AT91C_BASE_PMC->PMC_PCER = 1 << AT91C_ID_PWMC|
                               1 << AT91C_ID_ADC;// enabled by default

    // Set clock A to run at PWM_FREQUENCY * MAX_DUTY_CYCLE (clock B is not used)
    PWMC_ConfigureClocks(PWM_FREQUENCY * MAX_DUTY_CYCLE, 0, BOARD_MCK);

    // Configure PWMC channel #1 (left-aligned) (PWM1/TIOB0, pin 10 on J6 Header)
    PWMC_ConfigureChannel(1, AT91C_PWMC_CPRE_MCKA, 0, AT91C_PWMC_CPOL);
    PWMC_SetPeriod(1, MAX_DUTY_CYCLE);
    PWMC_SetDutyCycle(1, MIN_DUTY_CYCLE);

    // Configure interrupt on channel #1
    AIC_ConfigureIT(AT91C_ID_PWMC, 0, ISR_PWM);
    AIC_EnableIT(AT91C_ID_PWMC);              //Comment this line to disable ISR_PWM
    PWMC_EnableChannelIt(1);

    // Enable channel #1
    PWMC_EnableChannel(1);

    /* Insert ADC Initialization Below Here*/
    //ADC Initialization:
    //Configure ADC Mode Register
    //see AT91SAM7L128/64 Preliminary Datasheet Section 33.6.2 'ADC Mode Register'
    AT91C_BASE_ADC->ADC_MR =
        0<<0 | // hardware triger enable 0/1
        0<<1 | // triger source selection (0-6)
        0<<4 | // enable low resolution (8 bit) 0/1
        0<<5 | // use sleep mode (auto. wakeup on conversion 1mA -> 1uA) 0/1
        4<<8 | // ADC clk prescaler ADC_clk = MCI/2 / (prescaler+1)
        11<<16 | // STARTUP: Start up Time (hardware needs max 20us)
        2<<24; // SHTIM: track and hold time (min. 600ns)

    // configure channel enable register
    AT91C_BASE_ADC->ADC_CHER = 1<<3; // enable channel 3
    AT91C_BASE_ADC->ADC_CR = 1<<1; // start a new conversion
    /* Insert ADC Initialization Above Here*/     
    
    PIO_Clear(&Pins_3884[1]);
    PIO_Set(&Pins_3884[1]);

    // Infinite loop   
    while(1)
    {

    }  
}

